﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR.RiskManagement;

namespace QualityManagement.API.Controllers.Risk_Management
{
    /// <summary>
    /// Controller for RiskControl
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class RiskControlController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Creat A Risk Controller
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_RISK_CONTROL")]
        public async Task<IActionResult> CreateRiskControl(AddRiskControlCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get All RiskControl by Risk Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_RISK_CONTROL")]
        public async Task<IActionResult> GetAllRiskControl(Guid id)
        {
            var result = await _mediator.Send(new GetAllRiskControl() { RiskId = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// Update Risk Control by Id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        public async Task<IActionResult> UpdateRiskControl(Guid id, UpdateRiskControlCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }
    }
}
